<p align="center">
    <a href="https://www.question2answer.org/">
        <img src="https://www.question2answer.org/images/question2answer-logo-350x40.png" alt="Question2Answer" />
    </a>
</p>

<p align="center">
	<a href="https://travis-ci.org/q2a/question2answer/branches"><img src="https://img.shields.io/travis/q2a/question2answer/dev.svg" alt="Build Status"></a>
	<a href="https://github.com/q2a/question2answer/issues"><img src="https://img.shields.io/github/issues/q2a/question2answer.svg" alt="Open Issues"></a>
	<a href="https://github.com/q2a/question2answer/releases"><img src="https://img.shields.io/github/release/q2a/question2answer.svg" alt="Current Release"></a>
	<a href="https://docs.question2answer.org/install/"><img src="https://img.shields.io/travis/php-v/q2a/question2answer/dev.svg" alt="PHP version"></a>
	<a href="https://www.question2answer.org/license.php"><img src="https://img.shields.io/badge/License-GPL-green.svg" alt="License"></a>
</p>

[Question2Answer][Q2A] (Q2A) is a popular free open source Q&A platform for PHP/MySQL, used by over [22,000 sites in 40 languages][3].


## Key features

- Asking and answering questions (duh!)
- Voting, comments, best answer selection, follow-on and closed questions.
- Complete user management including points-based reputation management.
- Create experts, editors, moderators and admins.
- Fast integrated search engine, plus checking for similar questions when asking.
- Categories (up to 4 levels deep) and/or tagging.
- Easy styling with [CSS themes][6].
- Supports [translation][7] into any language.
- Custom sidebar, widgets, pages and links.
- SEO features such as neat URLs, microformats and XML Sitemaps.
- RSS, email notifications and personal news feeds.
- User avatars (or Gravatar) and custom fields.
- Private messages and public wall posts.
- Log in via Facebook or others (using plugins).
- Out-of-the-box WordPress 3+ integration.
- Out-of-the-box Joomla! 3.0+ integration (in conjunction with a Joomla! extension).
- Custom single sign-on support for other sites.
- PHP/MySQL scalable to millions of users and posts.
- Safe from XSS, CSRF and SQL injection attacks.
- Beat spam with captchas, rate-limiting, moderation and/or flagging.
- Block users, IP addresses, and censor words


## Plugins

Q2A also features an extensive [plugin system][5]:

- Modify the HTML output for a page with *layers*.
- Add custom pages to a Q2A site with *page modules*.
- Add extra content in various places with *widget modules*.
- Allow login via an external identity provider such as Facebook with *login modules*.
- Integrate WYSIWYG or other text editors with *editor/viewer modules*.
- Do something when certain actions take place with *event modules*.
- Validate and/or modify many types of user input with *filter modules*.
- Implement a custom search engine with *search modules*.
- Add extra spam protection with *captcha modules*.
- Extend many core Q2A functions using *function overrides*.

Q2A themes, plugins and language files created by other members are [available here][8].


## Development

Question2Answer is open source and we welcome contributions! The collaborative development process is being managed by [Scott Vivian][1]. Please read the [contributing page][2] for more information on how to get involved. We also have an [active community][4] where you can ask for help and discuss Q2A with other members.

Official releases can be found either on the [Q2A website][Q2A] or via the Releases tab on GitHub.


[Q2A]: https://www.question2answer.org/
[1]: https://www.question2answer.org/qa/user/Scott
[2]: https://github.com/q2a/question2answer/blob/master/CONTRIBUTING.md
[3]: https://www.question2answer.org/sites.php
[4]: https://www.question2answer.org/qa/
[5]: https://docs.question2answer.org/plugins/
[6]: https://docs.question2answer.org/themes/
[7]: https://docs.question2answer.org/translate/
[8]: https://docs.question2answer.org/addons/
