<?php

namespace App\Repository;

use App\Entity\Adherent;
use App\Entity\Flux;
use App\Entity\Prestataire;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method Flux|null find($id, $lockMode = null, $lockVersion = null)
 * @method Flux|null findOneBy(array $criteria, array $orderBy = null)
 * @method Flux[]    findAll()
 * @method Flux[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class FluxRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, Flux::class);
    }

   /**
    * @param  Prestataire $presta [description]
    * @return Query Returns a query fo finding an array of Flux
    */
    public function getQueryByPrestataire(Prestataire $presta)
    {
        $em = $this->getEntityManager();
        $connection = $em->getConnection();
        $statement = $connection->prepare("SELECT f.id FROM flux f WHERE f.prestataire_id = :id OR f.prestataire_dest_id = :id");
        $statement->bindValue('id', $presta->getId());
        $statement->execute();
        $results = $statement->fetchAll();
        $qb = $this->createQueryBuilder('f');
        return $qb
            ->where($qb->expr()->in('f.id', ':ids'))
            ->setParameter('ids', $results)
            ->getQuery()
        ;
    }

   /**
    * @param  Adherent $adherent [description]
    * @return Query Returns a query fo finding an array of Flux
    */
    public function getQueryByAdherent(Adherent $adherent)
    {
        $em = $this->getEntityManager();
        $connection = $em->getConnection();
        $statement = $connection->prepare("SELECT f.id FROM flux f WHERE f.adherent_id = :id");
        $statement->bindValue('id', $adherent->getId());
        $statement->execute();
        $results = $statement->fetchAll();
        $qb = $this->createQueryBuilder('f');
        return $qb
            ->where($qb->expr()->in('f.id', ':ids'))
            ->setParameter('ids', $results)
            ->getQuery()
        ;
    }
}
