<?php

namespace App\Factory;

use App\Entity\TransactionAdherentAdherent;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransactionPrestataireAdherent;
use App\Entity\TransactionPrestatairePrestataire;
use App\Entity\TransfertGroupeComptoir;
use App\Entity\TransfertSiegeGroupe;
use App\Entity\User;
use App\Form\Type\TransactionAdherentAdherentFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransactionPrestataireAdherentFormType;
use App\Form\Type\TransactionPrestatairePrestataireFormType;
use App\Form\Type\TransfertGroupeComptoirFormType;
use App\Form\Type\TransfertSiegeGroupeFormType;
use Symfony\Component\Form\FormFactoryInterface as FormF;
use Symfony\Component\Routing\RouterInterface;

class FormFactory
{
    public $ff;
    public $router;

    public function __construct(FormF $ff, RouterInterface $router)
    {
        $this->ff = $ff;
        $this->router = $router;
    }

    public function getTransactionAdherentAdherentForm(User $user)
    {
        if (empty($user) || empty($user->getAdherent())) {
            return null;
        }
        $entity = new TransactionAdherentAdherent();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getAdherent());
        $form = $this->ff->create(TransactionAdherentAdherentFormType::class, $entity, array('action' => $this->router->generate('transactionAdherentAdherent')));

        return $form->createView();
    }

    public function getTransactionAdherentPrestataireForm(User $user)
    {
        if (empty($user) || empty($user->getAdherent())) {
            return null;
        }
        $entity = new TransactionAdherentPrestataire();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getAdherent());
        $form = $this->ff->create(TransactionAdherentPrestataireFormType::class, $entity, array('action' => $this->router->generate('transactionAdherentPrestataire')));

        return $form->createView();
    }

    public function getTransactionPrestataireAdherentForm(User $user)
    {
        if (empty($user) || empty($user->getPrestataire())) {
            return null;
        }
        $entity = new TransactionPrestataireAdherent();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getPrestataire());
        $form = $this->ff->create(TransactionPrestataireAdherentFormType::class, $entity, array('action' => $this->router->generate('transactionPrestataireAdherent')));

        return $form->createView();
    }

    public function getTransactionPrestatairePrestataireForm(User $user)
    {
        if (empty($user) || empty($user->getPrestataire())) {
            return null;
        }
        $entity = new TransactionPrestatairePrestataire();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getPrestataire());
        $form = $this->ff->create(TransactionPrestatairePrestataireFormType::class, $entity, array('action' => $this->router->generate('transactionPrestatairePrestataire')));

        return $form->createView();
    }

    // public function getTransfertComptoirToXForm(User $user, $destinataire)
    // {
    //     $type = strtolower($type);
    //     if (empty($user) || empty($user->getComptoirsgere()) || !($type == 'adherent' || $type == 'groupe' || $type == 'prestataire')) {
    //         return null;
    //     }
    //     $class = 'TransactionComptoir'.ucwords($type);
    //     $entity = new $class();
    //     $entity->setOperateur($user);
    //     $entity->setExpediteur($user->getComptoirsgere());
    //     $form = $this->ff->create('App\Form\Type\TransactionComptoir'.ucwords($type).'FormType', $entity, array('action' => $this->router->generate('transactionComptoir'.ucwords($type))));

    //     return $form->createView();
    // }

    // public function getTransfertGroupeComptoirForm(User $user)
    // {
    //     $type = strtolower($type);
    //     if (empty($user) || empty($user->getGroupesgere())) {
    //         return null;
    //     }
    //     $class = 'Transaction'.ucwords($type).'Comptoir';
    //     $entity = new TransfertGroupeComptoir();
    //     $entity->setOperateur($user);
    //     $entity->setExpediteur($user->getGroupesgere());
    //     $form = $this->ff->create(TransfertGroupeComptoirFormType::class, $entity, array('action' => $this->router->generate('transfertGroupeComptoir')));

    //     return $form->createView();
    // }

    // public function getTransfertSiegeGroupeForm(User $user)
    // {
    //     if (empty($user) || !$user->hasRole('ROLE_ADMIN_SIEGE')) {
    //         return null;
    //     }
    //     $entity = new TransfertSiegeGroupe();
    //     $entity->setOperateur($user);
    //     $form = $this->ff->create(TransfertSiegeGroupeFormType::class, $entity, array('action' => $this->router->generate('transfertSiegeGroupe')));

    //     return $form->createView();
    // }
}
