<?php

namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransfertGroupeComptoir;
use App\Entity\Usergroup;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransfertGroupeComptoirFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class UserGestionnaireGroupeController extends AbstractController
{
    protected $em;
    protected $um;

    public function __construct(EntityManagerInterface $em, UserManagerInterface $um)
    {
        $this->em = $em;
        $this->um = $um;
    }

    /**
     * @Route("/groupe/infos", name="groupe_infos")
     * @IsGranted("ROLE_ADHERENT")
     */
    public function groupeInfosAction(Request $request)
    {
        // $form = $this->createForm(AdherentInfosFormType::class, $this->getUser()->getAdherent());
        // $form->handleRequest($request);

        // if ($form->isSubmitted() && $form->isValid()) {
        // }

        // return $this->render('adherent/infos.html.twig', array(
        //     'user' => $this->getUser(),
        //     'form' => $form->createView()
        // ));
    }

    /**
     * @Route("/groupe/transfert/comptoir/", name="transfertGroupeComptoir")
     * @IsGranted("ROLE_GESTION_GROUPE")
     */
    public function transfertGroupeComptoirAction(Request $request)
    {
        $entity = new TransfertGroupeComptoir();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertGroupeComptoirFormType::class, $entity);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                'Transfert bien effectuée !'
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->render('flux/transaction.html.twig', [
            'form' => $form->createView(),
            'compte' => $this->getUser()->getGroupesgere()->getCompte(),
            'title' => 'Transfert à un comptoir'
        ]);
    }
}
