<?php

namespace App\Admin;

use App\Admin\FluxAdmin;
use App\Entity\User;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType as SChoiceType;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Translation\TranslatorInterface;

class TransfertAdmin extends FluxAdmin
{
    protected $security;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $user = $this->security->getUser();
        $query = parent::createQuery($context);
        $query->andWhere($query->getRootAliases()[0].".parenttype = :type")
                ->setParameter('type', 'transfert');
        ;
        if ($user->isGranted('ROLE_GESTION_GROUPE') || $user->isGranted('ROLE_CONTACT')) {
            if (empty($user->getGroupesgere())) {
                $query->andWhere('false');
            } else {
                $groupe = $user->getGroupesgere();
                $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getEntityManager();
                $connection = $em->getConnection();
                $statement = $connection->prepare('SELECT f.id FROM flux f WHERE f.groupe_id = '.$groupe->getId().' OR (f.type = \'prestataire_siege\' AND f.prestataire_id IN (SELECT p.id FROM prestataire p WHERE p.groupe_id = '.$groupe->getId().'))');
                $statement->execute();
                $ids = $statement->fetchAll();
                $query
                    ->andWhere($query->expr()->in($query->getRootAliases()[0].'.id', ':ids'))
                    ->setParameter('ids', $ids)
                ;
            }
        }
        if ($user->isGranted('ROLE_COMPTOIR')) {
            if (empty($user->getComptoirsgere())) {
                $query->andWhere('false');
            } else {
                $comptoir = $user->getComptoirsgere();
                $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getEntityManager();
                $connection = $em->getConnection();
                $statement = $connection->prepare('SELECT f.id FROM flux f WHERE f.comptoir_id = '.$comptoir->getId().' OR f.user_id = '.$user->getId());
                $statement->execute();
                $ids = $statement->fetchAll();
                $query
                    ->andWhere($query->expr()->in($query->getRootAliases()[0].'.id', ':ids'))
                    ->setParameter('ids', $ids)
                ;
            }
        }
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('type', null, array(
                'label' => 'Type de transfert',
                'advanced_filter' => false,
                'show_filter' => true
            ))
            ->add('operateur', null, array(
                'label' => 'Operateur',
                'advanced_filter' => false,
                'show_filter' => true
            ))
        ;
    }
}
