/*
 * Welcome to your app's main JavaScript file!
 *
 * We recommend including the built version of this JavaScript file
 * (and its CSS file) in your base layout (base.html.twig).
 */

// any CSS you require will output into a single css file (app.css in this case)
require('../css/app.css');
require('../css/global.scss');

// Need jQuery? Install it with "yarn add jquery", then uncomment to require it.
// require jQuery normally
const $ = require('jquery');

// create global $ and jQuery variables
global.$ = global.jQuery = $;

// JS is equivalent to  the normal "bootstrap" package
// no need to set this to a variable, just require it
// require('popper.js/dist/popper.js');
require('bootstrap');

// leaftlet : for openstreetmap
require('../leaflet/leaflet.js');
// for flash message notification
require('../js/flash-messages.js');
const mlc = require('../js/mlc.js');

// can be use to sort with drag'n drop in sonata admin
// require('../../public/bundles/pixsortablebehavior/js/init.js');

$('#flash-messages').flashNotification('init');

var $collectionHolder;
// setup an "add a groupe presta (marché amap" link
var $addGroupeButton = $('<button type="button" class="add_groupe_link">Ajouter AMAP / Marché</button>');
var $newLinkLi = $('<p></p>').append($addGroupeButton);

/* */
function addGroupeForm($collectionHolder, $newLinkLi) {
    // Get the data-prototype explained earlier
    var prototype = $collectionHolder.data('prototype');

    // get the new index
    var index = $collectionHolder.data('index');

    // Replace '__name__' in the prototype's HTML to
    // instead be a number based on how many items we have
    var newForm = prototype.replace(/__name__/g, index);

    // increase the index with one for the next item
    $collectionHolder.data('index', index + 1);

    // Display the form in the page in an li, before the "Add a groupe" link li
    var $newFormLi = $('<p></p>').append(newForm);
    $newLinkLi.before($newFormLi);
}

jQuery(document).ready(function() {
	// Get the ul that holds the collection of groupes
	$collectionHolder = $('.groupeprestas');

	// add the "add a groupe" anchor and li to the groupes ul
	$collectionHolder.append($newLinkLi);

	// count the current form inputs we have (e.g. 2), use that as the new
	// index when inserting a new item (e.g. 2)
	$collectionHolder.data('index', $collectionHolder.find(':input').length);

	$addGroupeButton.on('click', function(e) {
	    // add a new groupe form (see next code block)
	    addGroupeForm($collectionHolder, $newLinkLi);
	});

	// BOOTSTRAP TOOLTIPS
	$('[data-toggle="tooltip"]').tooltip()
});
