<?php

namespace App\Form\Type;

use App\Enum\MoyenEnum;
use App\Form\Type\FluxFormType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;

class TransactionFormType extends FluxFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('moyen', HiddenType::class, array(
                'data' => MoyenEnum::MOYEN_VIREMENT
            ))
        ;
    }

    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransaction';
    }
}
