<?php

namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\TransactionAdherentAdherent;
use App\Enum\MoyenEnum;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransactionAdherentAdherentFormType extends TransactionFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => $this->security->getUser()->getAdherent()->getId(),
                'data_class' => null,
                'entity_class' => Adherent::class,
                'em' => $this->em
            ))
            ->add('destinataire', EntityType::class, array(
                'class' => Adherent::class,
                'choices' =>  $this->em->getRepository(Adherent::class)->findbyExclude($this->security->getUser()->getAdherent()),
                'placeholder' => 'Adherent',
                'required' => true,
                'label' => 'Adherent :',
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransactionAdherentAdherent::class,
        ));
    }

    public function getParent()
    {
        return TransactionFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransactionAdherentAdherent';
    }
}
