<?php

namespace App\Form\Type;

use App\Entity\Usergroup;
use App\Form\Type\RegistrationFormType;
use App\Form\Type\SiegeFormType;
use App\Form\Type\GlobalConfigurationFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class InstallFormType extends AbstractType
{
    protected $container;
    protected $em;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        $this->container = $container;
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('config', GlobalConfigurationFormType::class, array(
                'label' => 'CONFIGURATIONS GLOBALES :',
                'label_attr' => ['class' => 'font-weight-bold']
            ))
            ->add('groupe', FirstGroupeFormType::class, array(
                'label' => 'PREMIER GROUPE LOCAL',
                'label_attr' => ['class' => 'font-weight-bold'],
                'help' => "Au moins un groupe local est requis pour installer le Kohinos !"
            ))
            ->add('comptoir', FirstComptoirFormType::class, array(
                'label' => 'PREMIER COMPTOIR',
                'label_attr' => ['class' => 'font-weight-bold'],
                'help' => "Au moins un comptoir est requis pour installer le Kohinos !",
                'required' => true,
            ))
            ->add('siege', SiegeFormType::class, array(
                'label' => 'CONFIGURATION DU SIÈGE :',
                'label_attr' => ['class' => 'font-weight-bold']
            ))
            ->add('user', RegistrationFormType::class, array(
                'label' => "CRÉATION DE L'UTILISATEUR SUPER ADMIN :",
                'label_attr' => ['class' => 'font-weight-bold'],
                'required' => true
            ))
            ->add('save', SubmitType::class, ['label' => "Installer le système"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => null
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formInstallation';
    }
}
