<?php

namespace App\Form\Type;

use App\Entity\GlobalParameter;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class GlobalParameterType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', HiddenType::class, ['data' => $options['name_param']])
            ->add('mandatory', HiddenType::class, ['data' => $options['_mandatory']])
            ->add('value', TextType::class, array(
                'label' => false,
                'constraints' => $options['constraints_param'],
                'data' => $options['_data'],
                'attr' => array(
                    'placeholder' => $options['_placeholder']
                )
            ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => GlobalParameter::class,
            'required' => true,
            'name_param' => '',
            '_placeholder' => '',
            '_data' => null,
            '_mandatory' => true,
            'constraints_param' => [],
            'error_bubbling' => false,
            // 'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formSiege';
    }
}
