<?php

namespace App\Enum;

abstract class ImportEnum
{
    const IMPORT_GROUPE          = "groupe";
    const IMPORT_COMPTOIR        = "comptoir";
    const IMPORT_PRESTATAIRE     = "prestataire";
    const IMPORT_ADHERENT        = "adherent";

    /** @var array user friendly named type */
    protected static $typeName = [
        self::IMPORT_GROUPE        => 'Groupe(s)',
        self::IMPORT_COMPTOIR      => 'Comptoir(s)',
        self::IMPORT_PRESTATAIRE   => 'Prestataire(s)',
        self::IMPORT_ADHERENT      => 'Adherent(s)',
    ];

    /**
     * @param  string $typeShortName
     * @return string
     */
    public static function getTypeName($typeShortName)
    {
        if (!isset(static::$typeName[$typeShortName])) {
            return "Unknown type ($typeShortName)";
        }

        return static::$typeName[$typeShortName];
    }

    /**
     * @return array<string>
     */
    public static function getAvailableTypes()
    {
        return [
            self::IMPORT_GROUPE,
            self::IMPORT_COMPTOIR,
            self::IMPORT_PRESTATAIRE,
            self::IMPORT_ADHERENT
        ];
    }
}
