<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * VENTE
 *  - COMPTOIRS         =>     ADHERENTS                (Diffusion de monnaie papier auprès des adhérents)
 *
 * @ORM\Entity()
 */
class VenteComptoirAdherent extends Vente
{
    /**
     * @ORM\OneToOne(targetEntity="Adherent")
     * @ORM\JoinColumn(name="adherent_id", referencedColumnName="id")
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'comptoir_adherent';
    }

    public function getUsersToNotify()
    {
        return array_merge($this->getExpediteur()->getGestionnaires()->toArray(), [$this->getDestinataire()->getUser()]);
    }
}
