<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSFERT
 *  - PRESTATAIRES      =>     COMPTOIRS       (dépôt de billet et chargement du compte numérique)
 *
 * @ORM\Entity()
 */
class TransfertPrestataireComptoir extends Transfert
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id")
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'prestataire_comptoir';
    }

    public function operate($em)
    {
        $this->getExpediteur()->addEcompte($this->getMontant());
        $this->getDestinataire()->addCompte($this->getMontant());
        $this->getDestinataire()->getGroupe()->getSiege()->removeCompteNantie($this->getMontant());

        return [$this->getExpediteur(), $this->getDestinataire()];
    }

    public function getUsersToNotify()
    {
        return array_merge($this->getDestinataire()->getGestionnaires()->toArray(), $this->getExpediteur()->getUsers()->toArray());
    }
}
