<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSFERT
 *  - GROUPES LOCAUX    =>     COMPTOIRS                (Transfert du groupe au comptoir)
 *
 * @ORM\Entity()
 */
class TransfertGroupeComptoir extends Transfert
{
    /**
     * @ORM\OneToOne(targetEntity="Groupe")
     * @ORM\JoinColumn(name="groupe_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id")
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'groupe_comptoir';
    }
    
    public function getUsersToNotify()
    {
        return array_merge($this->getExpediteur()->getGestionnaires()->toArray(), $this->getDestinataire()->getGestionnaires()->toArray());
    }
}
