<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSFERT
 * Les transferts dans la structure sont les flux de billets détenus par les opérateurs.
 * Pour ajouter il faut un rôle spécifique :
 *   – Administrateur (Siège)
 *   – Gestionnaire (Groupe local)
 *   – Comptoir + Vente de monnaie locale
 *   – Prestataire (Reconversion)
 *
 * Types de transfert : (Les transferts dans la structure sont les flux de billets détenus par les opérateurs.)
 *
 *  - SIEGE             =>     GROUPES LOCAUX           (Transfert du siège au groupe)
 *  - GROUPE            =>     SIEGE                    (Transfert du groupe au siège)
 *  - GROUPES LOCAUX    =>     COMPTOIRS                (Transfert du groupe au comptoir)
 *  - COMPTOIRS         =>     GROUPES LOCAUX           (Transfert du comptoir au groupe)
 *  - COMPTOIRS         =>     ADHERENTS                (Diffusion de monnaie papier auprès des adhérents)
 *  - COMPTOIRS         =>     PRESTATAIRES             (Diffusion de monnaie papier auprès des prestataires)
 *  - PRESTATAIRES      =>     COMPTOIRS                (Reconversion)
 *
 * @ORM\Entity
 */
abstract class Transfert extends Flux
{
    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_TRANSFERT;
    }

    public function operate($em)
    {
        $compteExp = $this->getExpediteur()->getCompte() - $this->getMontant();
        if ($compteExp < 0) {
            throw new \Exception("[FLUX] Transfert impossible ! Montant supérieur au solde de l'expéditeur !");
        } else {
            $this->getExpediteur()->removeCompte($this->getMontant());
            $this->getDestinataire()->addCompte($this->getMontant());

            return [$this->getExpediteur(), $this->getDestinataire()];
        }
        return [];
    }
}
