<?php

namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * ApiResource(
 *     attributes={"security"="is_granted('ROLE_ADMIN_FAQ_GERER_VIEW')"},
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_FAQ_GERER_LIST')"},
 *         "post"={"security"="is_granted('ROLE_ADMIN_FAQ_GERER_EDIT')"}
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_FAQ_GERER_VIEW')"},
 *         "put"={"security"="is_granted('ROLE_ADMIN_FAQ_GERER_EDIT')"},
 *     },
 *     normalizationContext={"groups"={"read"}},
 *     denormalizationContext={"groups"={"write"}}
 * )
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Table(name="faq")
 */
class Faq
{
    use TimestampableEntity,
        EnablableEntityTrait,
        NameSlugContentEntityTrait;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
    * @var \Application\Sonata\MediaBundle\Entity\Media
    * @ORM\ManyToOne(targetEntity="App\Application\Sonata\MediaBundle\Entity\Media", cascade={"persist"}, fetch="LAZY")
    * @ORM\JoinColumn(name="fichier_id", referencedColumnName="id", nullable=true)
    */
    protected $fichier;

    /**
    * @var \Application\Sonata\MediaBundle\Entity\Media
    * @ORM\ManyToOne(targetEntity="App\Application\Sonata\MediaBundle\Entity\Media", cascade={"persist"}, fetch="LAZY")
    * @ORM\JoinColumn(name="media_id", referencedColumnName="id", nullable=true)
    */
    protected $image;

    /**
     * @var null|User
     *
     * @ORM\ManyToOne(targetEntity="User", inversedBy="faqs", cascade={"persist"})
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     */
    private $user;

    /**
     * @return mixed
     */
    public function getId(): int
    {
        return $this->id;
    }

    public function getText(): ?string
    {
        return $this->text;
    }

    public function setText(?string $text): self
    {
        $this->text = $text;

        return $this;
    }

    /**
     * @return null|User
     */
    public function getUser(): ?User
    {
        return $this->user;
    }

    /**
     * @param null|User $user
     * @return $this
     */
    public function setUser(?User $user)
    {
        $this->user = $user;
        return $this;
    }

    /**
     * @return Media|null
     */
    public function getFichier()
    {
        return $this->fichier;
    }

    /**
     * @param Media|null $fichier
     * @return Faq
     */
    public function setFichier($fichier)
    {
        $this->fichier = $fichier;
        return $this;
    }

    /**
    * Get image
    * @return image|null
    */
    public function getImage()
    {
        return $this->image;
    }

    /**
    * Set image
    * @return $this
    */
    public function setImage($image)
    {
        $this->image = $image;
        return $this;
    }

    public function __toString(): string
    {
        return $this->getTitle()?$this->getTitle():'FAQ';
    }
}
