<?php

namespace App\Controller;

use App\Entity\Prestataire;
use App\Entity\Rubrique;
use App\Entity\TransactionPrestataireAdherent;
use App\Entity\TransfertPrestataireSiege;
use App\Entity\TypePrestataire;
use App\Entity\AchatMonnaiePrestataire;
use App\Entity\Payment;
use App\Form\Type\GroupePrestataireInscriptionFormType;
use App\Form\Type\PrestataireInfosFormType;
use App\Form\Type\TransactionPrestataireAdherentFormType;
use App\Form\Type\TransfertPrestataireSiegeFormType;
use App\Form\Type\AchatMonnaiePrestataireFormType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserPrestataireController extends FluxController
{
    /**
     * @Route("/prestataireinfos", name="prestataire_infos")
     * @IsGranted("ROLE_PRESTATAIRE")
     */
    public function prestataireInfosAction(Request $request)
    {
        $form = $this->createForm(PrestataireInfosFormType::class, $this->session->get('_prestagere'));
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->em->persist($form->getData());
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Infos du prestataire modifiée !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->redirectToRoute('index');
    }

    /**
     * @Route("/prestatairegroupes/inscription", name="groupeprestataire_inscription")
     * @IsGranted("ROLE_PRESTATAIRE")
     */
    public function groupePrestataireInscriptionAction(Request $request)
    {
        $form = $this->createForm(GroupePrestataireInscriptionFormType::class, $this->session->get('_prestagere'));
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $prestataire = $form->getData();
            $this->em->persist($prestataire);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Information bien prise en compte !')
            );
            if ($request->isXmlHttpRequest()) {
                return new JsonResponse(array('status' => 'success'));
            } else {
                $referer = $request->headers->get('referer');
                if ($referer && !$request->isXmlHttpRequest()) {
                    return $this->redirect($referer);
                } elseif (!$request->isXmlHttpRequest()) {
                    return new Response('', Response::HTTP_BAD_REQUEST);
                }
            }
        }

        return $this->redirectToRoute('index');
    }

    /**
     * @Route("/prestataire/transaction/{type}/", name="transactionPrestataireAdherent", defaults={"type": "adherent"})
     * @Route("/prestataire/transaction/{type}/", name="transactionPrestatairePrestataire", defaults={"type": "prestataire"})
     * @IsGranted("ROLE_PRESTATAIRE")
     */
    public function transactionPrestataireAction($type, Request $request)
    {
        $entityName = 'App\Entity\TransactionPrestataire'.ucwords($type);
        $entity = new $entityName();
        $entity->setOperateur($this->getUser());
        $entity->setExpediteur($this->session->get('_prestagere'));
        $form = $this->createForm('App\Form\Type\TransactionPrestataire'.ucwords($type).'FormType', $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_prestagere')->getEcompte(),
            $this->translator->trans('Transaction bien effectuée !'),
            $this->translator->trans('Transaction à un ').$type
        );
    }


    /**
     * @Route("/prestataire/transfert/siege/", name="transactionPrestataireSiege")
     * @IsGranted("ROLE_PRESTATAIRE")
     */
    public function transfertPrestataireSiegeAction(Request $request)
    {
        $entity = new TransfertPrestataireSiege();
        $entity->setOperateur($this->getUser());
        $entity->setExpediteur($this->session->get('_prestagere'));
        $form = $this->createForm(TransfertPrestataireSiegeFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_prestagere')->getEcompte(),
            $this->translator->trans('Reconversion envoyée, elle sera validée lorsque le virement sera effectué !'),
            $this->translator->trans('Reconversion de monnaie au siège')
        );
    }

    /**
     * @Route("/prestataire/achat-monnaie/", name="achatMonnaiePrestataire")
     * @IsGranted("ROLE_PRESTATAIRE")
     */
    public function achatMonnaiePrestataireAction(Request $request)
    {
        if (empty($this->getUser()) || empty($this->session->get('_prestagere'))) {
            return $this->redirectToRoute('index');
        }

        $entity = new AchatMonnaiePrestataire();
        $form = $this->createForm(AchatMonnaiePrestataireFormType::class, $entity);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
          return $this->preparePaymentAction(
            $form,
            Payment::TYPE_ACHAT_MONNAIE_PRESTA
          );
        }

        return $this->render('flux/transaction.html.twig', [
            'form' => $form->createView(),
            'title' => $this->translator->trans('Achat de monnaie locale')
        ]);
    }

}
