<?php

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Administration des paramètres généraux de l'outil de MLC
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class GlobalParameterAdmin extends AbstractAdmin
{
    protected $translator;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $formMapper
            ->add('name', TextType::class, array(
                'label' => 'Nom :',
                'attr' => array( 'class' => 'text-uppercase' )
            ))
            ->add('value', TextType::class, array(
                'label' => 'Valeur :'
            ))
            ->add('mandatory', HiddenType::class, array(
                'empty_data' => false,
                'data' => false
            ))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->add('name', null, array('label' => 'Nom'))
            ->add('value', null, array('editable' => true, 'truncate' => array('length' => 80), 'label' => 'Value'))
            ->add('_action', null, [
                'label' => 'Action(s)',
                'actions' => [
                    'edit' => ['template' => '@SonataAdmin/CRUD/list__action_edit_gp.html.twig'],
                    'delete' => ['template' => '@SonataAdmin/CRUD/list__action_delete_gp.html.twig'],
                ]
            ])
        ;
    }

    public function getBatchActions()
    {
        $actions = parent::getBatchActions();
        unset($actions['delete']);
        unset($actions['edit']);

        return $actions;
    }
}
