<?php

namespace App\Form\Type;

use App\Entity\Comptoir;
use App\Entity\Groupe;
use App\Entity\TransfertComptoirGroupe;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransfertComptoirGroupeFormType extends TransfertFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => $this->security->getUser()->getComptoirsgere()->getId(),
                'data_class' => null,
                'entity_class' => Comptoir::class,
                'em' => $this->em
            ))
            ->add('destinataire', EntityType::class, array(
                'class' => Groupe::class,
                'choices' =>  $this->em->getRepository(Groupe::class)->findBy(array('enabled' => true)),
                'placeholder' => 'Groupe',
                'required' => true,
                'label' => 'Groupe :',
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransfertComptoirGroupe::class,
        ));
    }

    public function getParent()
    {
        return TransfertFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransfertComptoirGroupe';
    }
}
