<?php

namespace App\Form\Type;

use App\Entity\Import;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ImportFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('media', MediaType::class, array(
                'provider' => 'sonata.media.provider.file',
                'context' => 'import',
                'label' => 'Fichier (.csv)'
            ))

            ->add('user', HiddenType::class, array(
                'label' => false
            ))
            ->add('save', SubmitType::class, ['label' => "Importer les données"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Import::class,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formImport';
    }
}
