<?php

namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\GeolocEntityTrait;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;

/**
 * @ORM\Entity(repositoryClass="App\Repository\AdherentRepository")
 * @ORM\Table(name="adherent")
 */
class Adherent
{
    use EnablableEntityTrait,
        TimestampableEntity,
        GeolocEntityTrait;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="decimal", precision=7, scale=2)
     */
    private $ecompte;

    /**
     * @var User
     *
     * @ORM\OneToOne(targetEntity="User", cascade={"all"}, mappedBy="adherent", fetch="EAGER")
     */
    protected $user;

    /**
     * @var Groupe $groupe
     *
     * @ORM\ManyToOne(targetEntity="Groupe", inversedBy="adherents")
     */
    private $groupe;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEcompte(): float
    {
        return $this->ecompte;
    }

    public function setEcompte(float $ecompte): self
    {
        $this->ecompte = $ecompte;

        return $this;
    }

    public function getCompte(): float
    {
        return $this->ecompte;
    }

    public function setCompte(float $ecompte): self
    {
        $this->ecompte = $ecompte;

        return $this;
    }

    /**
     * @return User
     */
    public function getUser(): ?User
    {
        return $this->user;
    }

    /**
     * @param User $user
     * @return Prestataire
     */
    public function setUser(User $user): self
    {
        $this->user = $user;
        return $this;
    }

    /**
     * @param null|Groupe $groupe
     * @return $this
     */
    public function setGroupe(?Groupe $groupe)
    {
        $this->groupe = $groupe;
        return $this;
    }

    /**
     * @return null|Groupe
     */
    public function getGroupe(): ?Groupe
    {
        return $this->groupe;
    }


    public function isEnabled(): bool
    {
        return $this->getUser()->isEnabled();
    }

    public function setEnabled($enabled): self
    {
        $this->getUser()->setEnabled($enabled);
        return $this;
    }

    public function __toString(): string
    {
        return (!empty($this->getUser() && $this->getUser()->getUsername())?$this->getUser()->getUsername():'Adherent '.$this->getId());
    }
}
