<?php

namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\Groupe;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransfertComptoirAdherent;
use App\Entity\TransfertPrestataireComptoir;
use App\Entity\Usergroup;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\GroupeInfosFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransfertComptoirAdherentFormType;
use App\Form\Type\TransfertPrestataireComptoirFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserComptoirController extends AbstractController
{
    protected $translator;

    public function __construct(EntityManagerInterface $em, TranslatorInterface $translator)
    {
        $this->em = $em;
        $this->translator = $translator;
    }

    /**
     * @Route("/user/comptoir/infos", name="comptoir_infos")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function groupeInfosAction(Request $request)
    {
        $form = $this->createForm(ComptoirInfosFormType::class, $this->getUser()->getComptoirsgere());
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Comptoir bien modifié !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->redirectToRoute('index');
    }

    /**
     * @Route("/user/comptoir/transfert/adherent/", name="transfertComptoirAdherent")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function transfertComptoirAdherentAction(Request $request)
    {
        $entity = new TransfertComptoirAdherent();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertComptoirAdherentFormType::class, $entity);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Transfert bien effectuée !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->render('flux/transaction.html.twig', [
            'form' => $form->createView(),
            'compte' => $this->getUser()->getComptoirsgere()->getCompte(),
            'title' => $this->translator->trans('Transfert à un adhérent')
        ]);
    }

    /**
     * @Route("/user/comptoir/reconversion/", name="transfertPrestataireComptoir")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function transfertPrestataireComptoirAction(Request $request)
    {
        $entity = new TransfertPrestataireComptoir();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertPrestataireComptoirFormType::class, $entity);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Reconversion bien effectuée !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->render('flux/transaction.html.twig', [
            'form' => $form->createView(),
            'compte' => $this->getUser()->getComptoirsgere()->getCompte(),
            'title' => $this->translator->trans("Reconversion d'un prestataire")
        ]);
    }
}
