<?php

namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\TransactionAdherentAdherent;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\Usergroup;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\TransactionAdherentAdherentFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserAdherentController extends AbstractController
{
    protected $em;
    protected $translator;

    public function __construct(EntityManagerInterface $em, TranslatorInterface $translator)
    {
        $this->em = $em;
        $this->translator = $translator;
    }

    /**
     * @Route("/adherent/infos", name="adherent_infos")
     * @IsGranted("ROLE_ADHERENT")
     */
    public function adherentInfosAction(Request $request)
    {
        $form = $this->createForm(AdherentInfosFormType::class, $this->getUser()->getAdherent());
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->em->persist($form->getData());
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Infos du prestataire modifiée !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->redirectToRoute('index');
    }

    /**
     * @Route("/adherent/transaction/prestataire/", name="transactionAdherentPrestataire")
     * @IsGranted("ROLE_ADHERENT")
     */
    public function transactionAdherentPrestataireAction(Request $request)
    {
        $entity = new TransactionAdherentPrestataire();
        $entity->setOperateur($this->getUser());
        $entity->setExpediteur($this->getUser()->getAdherent());
        $form = $this->createForm(TransactionAdherentPrestataireFormType::class, $entity);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Transaction bien effectuée !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->render('flux/transaction.html.twig', [
            'form' => $form->createView(),
            'compte' => $this->getUser()->getAdherent()->getCompte(),
            'title' => $this->translator->trans('Transaction à un prestataire')
        ]);
    }

    /**
     * @Route("/adherent/transaction/adherent/", name="transactionAdherentAdherent")
     * @IsGranted("ROLE_ADHERENT")
     */
    public function transactionAdherentAdherentAction(Request $request)
    {
        if (empty($this->getUser()) || empty($this->getUser()->getAdherent())) {
            return $this->redirectToRoute('index');
        }
        $entity = new TransactionAdherentAdherent();
        $entity->setOperateur($this->getUser());
        $entity->setExpediteur($this->getUser()->getAdherent());
        $form = $this->createForm(TransactionAdherentAdherentFormType::class, $entity);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Transaction bien effectuée !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->render('flux/transaction.html.twig', [
            'form' => $form->createView(),
            'compte' => $this->getUser()->getAdherent()->getCompte(),
            'title' => $this->translator->trans('Transaction à un adhérent')
        ]);
    }
}
