<?php

namespace App\Admin;

use App\Admin\FluxAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;

/**
 * Administration des transactions
 *
 * LOCO : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class TransactionAdmin extends FluxAdmin
{
    protected $translator;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        $query->andWhere($query->getRootAliases()[0].".parenttype = :type")
                ->setParameter('type', 'transaction');
        ;
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('type', null, array(
                'label' => 'Type de transaction',
                'advanced_filter' => false,
                'show_filter' => true
            ))
            ->add('operateur', null, array(
                'label' => 'Operateur',
                'advanced_filter' => false,
                'show_filter' => true
            ))
        ;
    }
}
