<?php

namespace App\Admin;

use App\Entity\Comptoir;
use App\Entity\Prestataire;
use App\Entity\Siege;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Security\Core\Security;

/**
 * Administration des rubriques
 *
 * LOCO : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class RubriqueAdmin extends AbstractAdmin
{
    protected $security;
    protected $datagridValues = [
        '_sort_order' => 'ASC',
        '_sort_by' => 'name',
    ];

    public function configure()
    {
        parent::configure();
    }

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $user = $this->security->getUser();
        $prestataires = $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Prestataire::class)->findBy(array('enabled' => true));
        // if (($user->isGranted('ROLE_GESTION_GROUPE') || $user->isGranted('ROLE_CONTACT')) && $this->security->getUser()->getGroupesgere() != null) {
        //     $prestataires = $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Prestataire::class)->findBy(array('enabled' => true, 'groupe' => $this->security->getUser()->getGroupesgere()));
        // }
        $groupe = $this->getSubject();
        $formMapper
            ->with("Création d'une rubrique")
                ->add('name', TextType::class, array(
                    'label' => 'Nom :',
                    'required' => true
                ))
                ->add('content', CKEditorType::class, array(
                    'label' => 'Description :',
                    'required' => false,
                ))
                ->add('prestataires', CollectionType::class, array(
                    'label' => 'Prestataires',
                    'entry_type' => EntityType::class,
                    'entry_options' => array(
                        'class' => Prestataire::class,
                        'choices' =>  $prestataires,
                        // 'choice_label' => 'name',
                        'placeholder' => 'Choisir un prestataire',
                        'required' => false,
                        'label' => false),
                    'by_reference' => false,
                    'allow_add' => true,
                    'allow_delete' => true
                ))
                ->add('enabled', CheckboxType::class, array(
                    'label' => 'Activé ?',
                    'required' => false,
                    'label_attr' => array('class' => 'checkbox-inline')
                ))
            ->end()
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    // public function getBatchActions()
    // {
    //     $actions = parent::getBatchActions();
    //     unset($actions['delete']);

    //     return $actions;
    // }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array('label' => 'Nom du groupe'))
            ->addIdentifier('content', 'html', array('truncate' => array('length' => 80), 'label' => 'Description'))
            ->add(
                'getPrestatairesCount',
                null,
                [
                    'label' => 'Nb prestataires',
                    'sortable' => true,
                    'sort_field_mapping' => ['fieldName' => 'id'],
                    'sort_parent_association_mappings' => [],
                ]
            )
            ->addIdentifier('enabled', null, array('label' => 'Activé', 'datatype' => 'App.Groupeprestataire', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
        ;
    }
}
