<?php

namespace App\Admin;

use App\Entity\Geoloc;
use App\Form\Type\GeolocFormType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Security\Core\Security;

/**
 * Administration des comptoirs
 *
 * LOCO : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class ComptoirAdmin extends AbstractAdmin
{
    protected $security;
    protected $datagridValues = [
        '_sort_order' => 'ASC',
        '_sort_by' => 'name',
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        $user = $this->security->getUser();
        if ($user->isGranted('ROLE_GESTION_GROUPE') || $user->isGranted('ROLE_CONTACT')) {
            if (empty($user->getGroupesgere())) {
                $query->andWhere('false');
            } else {
                $groupe = $user->getGroupesgere();
                $query
                    ->andWhere($query->getRootAliases()[0] . '.groupe = :group')
                    ->setParameter('group', $groupe)
                ;
            }
        }
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $comptoir = $this->getSubject();
        if ($this->isCurrentRoute('create')) {
            $geoloc = new Geoloc();
            $comptoir->setGeoloc($geoloc);
        }
        $formMapper
            ->with('Comptoir', ['class' => 'col-md-8'])
                ->add('groupe', null, array(
                    'label' => 'Groupe local',
                    'required' => true,
                ))
                ->add('name', null, array(
                    'label' => 'Nom',
                    'required' => true,
                ))
                ->add('email', null, array(
                    'label' => 'Email',
                    'required' => true,
                ))
                ->add('tel', null, array(
                    'label' => 'Téléphone',
                    'required' => true,
                ))
                ->add('enabled', null, array('label' => 'Activé ?'))
            ->end()
            ->with('Geoloc', ['class' => 'col-md-4'])
                ->add('geoloc', GeolocFormType::class, array(
                    'label' => false,
                    'required' => true
                ))
            ->end()
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('enabled')
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name')
            ->addIdentifier('email')
            ->addIdentifier('compte', null, array('label' => 'Solde'))
            ->addIdentifier('geoloc.adresse')
            ->addIdentifier('tel')
            ->addIdentifier('enabled', null, array('label' => 'Activé', 'datatype' => 'App.Comptoir', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
        ;
    }
}
