<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Repository;

use App\Entity\Comptoir;
use App\Entity\Rubrique;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Common\Persistence\ManagerRegistry;

/**
 * @method Comptoir|null find($id, $lockMode = null, $lockVersion = null)
 * @method Comptoir|null findOneBy(array $criteria, array $orderBy = null)
 * @method Comptoir[]    findAll()
 * @method Comptoir[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ComptoirRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Comptoir::class);
    }

    /**
    * @return Comptoir[] Returns an array of Comptoir objects
    */
    public function findByGeoloc($lat, $lon, $distance)
    {
        $sqlDistance = '(6373000 * acos(cos(radians(' . $lat . ')) * cos(radians(g.lat)) * cos(radians(g.lon) - radians(' . $lon . ')) + sin(radians(' . $lat . ')) * sin(radians(g.lat))))';
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->leftJoin('p.geoloc', 'g')
            ->andWhere('p.enabled = :enabled')
            ->setParameter('enabled', true)
            ->andWhere("" . $sqlDistance . " < :distance")
            ->setParameter('distance', $distance)
            ->orderBy('p.name', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }
}
