<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\GlobalParameter;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class GlobalParameterType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', HiddenType::class, ['data' => $options['name_param']])
            ->add('mandatory', HiddenType::class, ['data' => $options['_mandatory']])
            ->add('value', TextType::class, array(
                'label' => false,
                'constraints' => $options['constraints_param'],
                'data' => $options['_data'],
                'attr' => array(
                    'placeholder' => $options['_placeholder']
                )
            ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => GlobalParameter::class,
            'required' => true,
            'name_param' => '',
            '_placeholder' => '',
            '_data' => null,
            '_mandatory' => true,
            'constraints_param' => [],
            'error_bubbling' => false,
            // 'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formSiege';
    }
}
