<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Cotisation;
use App\Entity\GlobalParameter;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationInfosFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Validator\Constraints\NotBlank;

class AddCotisationFormType extends AbstractType
{
    protected $em;
    protected $security;

    public function __construct(EntityManagerInterface $em, Security $security)
    {
        $this->em = $em;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $now = new \DateTime();
        $builder
            ->add('reference', HiddenType::class, array(
                'label' => 'Reference :',
                'required' => true,
                'data' => 'Adhésion '.$now->format('d/m/Y')
            ))
            ->add('montant', IntegerType::class, array(
                'data' => intval($this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::COTISATION_ADHERENT)),
                'constraints' => [
                    new NotBlank()
                ],
            ))
            ->add('moyen', HiddenType::class, array(
                'data' => MoyenEnum::MOYEN_CB,
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Cotisation::class,
            'cascade_validation' => true
        ));
    }

    public function getBlockPrefix()
    {
        return 'formAddCotisation';
    }
}
