<?php
namespace App\EventListener;
/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Role\SwitchUserRole;
use Symfony\Component\Security\Http\Event\SwitchUserEvent;
use Symfony\Component\Security\Http\SecurityEvents;
use Symfony\Component\Security\Core\Authentication\Token\SwitchUserToken;

class SwitchUserSubscriber implements EventSubscriberInterface
{
    private $router;
    private $em;

    /**
     * SwitchUserSubscriber constructor.
     *
     * @param RouterInterface $router
     */
    public function __construct(RouterInterface $router, EntityManagerInterface $em)
    {
        $this->router = $router;
        $this->em = $em;
    }

    /**
     * Super admin switches user
     */
    public function onSwitchUser(SwitchUserEvent $event)
    {
        $request = $event->getRequest();
        $token = $event->getToken();
        $user = $event->getTargetUser();

        $request->getSession()->remove('_prestagere');
        $request->getSession()->remove('_comptoirgere');
        $request->getSession()->remove('_groupegere');

        if ($user->getPossiblegroups()->count() == 1) {
            if (count($user->getGroups()) != 1) {
                $groupe = $user->getPossiblegroups()->first();
                if (in_array('ROLE_PRESTATAIRE', $groupe->getRoles()) && count($user->getPrestataires()) >= 1) {
                    $request->getSession()->set('_prestagere', $user->getPrestataires()[0]);
                } elseif (in_array('ROLE_CAISSIER_PRESTATAIRE', $groupe->getRoles()) && count($user->getCaissierprestataires()) >= 1) {
                    $request->getSession()->set('_prestagere', $user->getCaissierprestataires()[0]);
                } elseif (in_array('ROLE_COMPTOIR', $groupe->getRoles()) && count($user->getComptoirsGeres()) >= 1) {
                    $request->getSession()->set('_comptoirgere', $user->getComptoirsGeres()[0]);
                } elseif (in_array('ROLE_CAISSIER_COMPTOIR', $groupe->getRoles()) && count($user->getCaissiercomptoirs()) >= 1) {
                    $request->getSession()->set('_comptoirgere', $user->getCaissiercomptoirs()[0]);
                } elseif ((in_array('ROLE_TRESORIER', $groupe->getRoles()) || in_array('ROLE_CONTACT', $groupe->getRoles()) || in_array('ROLE_GESTION_GROUPE', $groupe->getRoles())) && count($user->getGroupesGeres()) >= 1) {
                    $request->getSession()->set('_groupegere', $user->getGroupesGeres()[0]);
                }
                $user->setGroups([$groupe]);
                $this->em->persist($user);
                $this->em->flush();
                $this->updateToken($event, $user, $token);
            } else {
                $groupe = $user->getGroups()->first();
                if (in_array('ROLE_PRESTATAIRE', $groupe->getRoles()) && count($user->getPrestataires()) >= 1) {
                    $request->getSession()->set('_prestagere', $user->getPrestataires()[0]);
                } elseif (in_array('ROLE_CAISSIER_PRESTATAIRE', $groupe->getRoles()) && count($user->getCaissierprestataires()) >= 1) {
                    $request->getSession()->set('_prestagere', $user->getCaissierprestataires()[0]);
                } elseif (in_array('ROLE_COMPTOIR', $groupe->getRoles()) && count($user->getComptoirsGeres()) >= 1) {
                    $request->getSession()->set('_comptoirgere', $user->getComptoirsGeres()[0]);
                } elseif (in_array('ROLE_CAISSIER_COMPTOIR', $groupe->getRoles()) && count($user->getCaissiercomptoirs()) >= 1) {
                    $request->getSession()->set('_comptoirgere', $user->getCaissiercomptoirs()[0]);
                } elseif ((in_array('ROLE_TRESORIER', $groupe->getRoles()) || in_array('ROLE_CONTACT', $groupe->getRoles()) || in_array('ROLE_GESTION_GROUPE', $groupe->getRoles())) && count($user->getGroupesGeres()) >= 1) {
                    $request->getSession()->set('_groupegere', $user->getGroupesGeres()[0]);
                }
            }
        } elseif ($user->getPossiblegroups()->count() > 1) {
            if ($user->getGroups()->count() != 1) {
                $hasSuperAdminRole = false;
                foreach ($user->getPossiblegroups() as $groupe) {
                    if (in_array('ROLE_SUPER_ADMIN', $groupe->getRoles())) {
                        $hasSuperAdminRole = true;
                        $user->setGroups([]);
                        $this->em->persist($user);
                        $this->em->flush();
                        $user->setGroups([$groupe]);
                        $this->em->persist($user);
                        $this->em->flush();
                        $this->updateToken($event, $user, $token);
                    }
                }
                if (!$hasSuperAdminRole) {
                    $user->setGroups([]);
                    $user->setRoles(['ROLE_USER']);
                    $this->em->persist($user);
                    $this->em->flush();
                    $this->updateToken($event, $user, $token);
                }
            } else {
                $groupe = $user->getGroups()->first();
                if (in_array('ROLE_PRESTATAIRE', $groupe->getRoles()) && count($user->getPrestataires()) >= 1) {
                    $request->getSession()->set('_prestagere', $user->getPrestataires()[0]);
                } elseif (in_array('ROLE_CAISSIER_PRESTATAIRE', $groupe->getRoles()) && count($user->getCaissierprestataires()) >= 1) {
                    $request->getSession()->set('_prestagere', $user->getCaissierprestataires()[0]);
                } elseif (in_array('ROLE_COMPTOIR', $groupe->getRoles()) && count($user->getComptoirsGeres()) >= 1) {
                    $request->getSession()->set('_comptoirgere', $user->getComptoirsGeres()[0]);
                } elseif (in_array('ROLE_CAISSIER_COMPTOIR', $groupe->getRoles()) && count($user->getCaissiercomptoirs()) >= 1) {
                    $request->getSession()->set('_comptoirgere', $user->getCaissiercomptoirs()[0]);
                } elseif ((in_array('ROLE_TRESORIER', $groupe->getRoles()) || in_array('ROLE_CONTACT', $groupe->getRoles()) || in_array('ROLE_GESTION_GROUPE', $groupe->getRoles())) && count($user->getGroupesGeres()) >= 1) {
                    $request->getSession()->set('_groupegere', $user->getGroupesGeres()[0]);
                }
            }
        }
    }

    private function updateToken($event, $user, $token)
    {
        $roles = $user->getRoles();
        $roles[] = new SwitchUserRole('ROLE_PREVIOUS_ADMIN', $token, false);
        $token = new SwitchUserToken($user, $user->getPassword(), 'main', $roles, $event->getToken()->getOriginalToken());

        $event->setToken($token);
    }

    public static function getSubscribedEvents()
    {
        return [
            // constant for security.switch_user
            SecurityEvents::SWITCH_USER => 'onSwitchUser',
        ];
    }
}
