<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Vente => (Diffusion de monnaie papier auprès des adhérents)
 *
 * Types de vente :
 *
 *   - COMPTOIR     =>    ADHERENTS         (Vente à un adherent)
 *   - COMPTOIR     =>    PRESTATAIRES      (Vente à un prestataire)
 *
 * @ORM\Entity
 */
abstract class Vente extends Flux
{
    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_VENTE;
    }

    public function operate($em)
    {
        $compteExp = $this->getExpediteur()->getCompte() - $this->getMontant();
        if ($compteExp < 0) {
            throw new \Exception("[FLUX] Vente impossible ! Montant supérieur au solde du comptoir !");
        } else {
            $this->getExpediteur()->removeCompte($this->getMontant());
            $this->getExpediteur()->setUpdatedAt(new \DateTime());
            $this->getExpediteur()->getGroupe()->getSiege()->addCompteNantie($this->getMontant());

            return [$this->getExpediteur(), $this->getExpediteur()->getGroupe()->getSiege()];
        }
        return [];
    }
}
