<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Retrait => (Retrait de monnaie papier en échange de monnaie numérique).
 *
 * Types de retraits :
 *
 *   - ADHERENTS        =>    COMPTOIR         (Retrait d'un adherent)
 *   - PRESTATAIRES     =>    COMPTOIR      (Retrait d'un prestataire)
 *
 * @ORM\Entity
 */
abstract class Retrait extends Flux
{
    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_RETRAIT;
    }

    public function operate($em)
    {
        $compteExp = $this->getExpediteur()->getCompte() - $this->getMontant();
        $compteDest = $this->getDestinataire()->getEcompte() - $this->getMontant();
        if ($compteExp < 0) {
            throw new \Exception('[FLUX] Retrait impossible ! Montant supérieur au solde du comptoir !');
        } elseif ($compteDest < 0) {
            throw new \Exception('[FLUX] Retrait impossible ! Montant supérieur au solde du demandeur !');
        } else {
            $this->getExpediteur()->removeCompte($this->getMontant());
            $this->getExpediteur()->getGroupe()->getSiege()->addCompteNantie($this->getMontant());
            $this->getDestinataire()->removeEcompte($this->getMontant());

            return [$this->getExpediteur(), $this->getDestinataire(), $this->getExpediteur()->getGroupe()->getSiege()];
        }

        return [];
    }
}
