<?php
namespace App\Entity;
/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 

use Doctrine\ORM\Mapping as ORM;
use Payum\Core\Model\Payment as BasePayment;

/**
 * @ORM\Entity(repositoryClass="App\Repository\PaymentRepository")
 * @ORM\Table(name="payment")
 */
class Payment extends BasePayment
{
    const TYPE_ACHAT_MONNAIE_ADHERENT   = 'achat_monnaie_adherent';
    const TYPE_ACHAT_MONNAIE_PRESTA     = 'achat_monnaie_presta';
    const TYPE_COTISATION_ADHERENT      = 'cotisation_adherent';
    const TYPE_COTISATION_PRESTA        = 'cotisation_presta';
    const TYPE_ADHESION                 = 'adhesion';


    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     *
     * @var integer $id
     */
    protected $id;

    /**
     * @var string|null
     *
     * @ORM\Column(type="string", length=50, nullable=true)
     */
     protected $status;

     /**
      * @var string|null
      * JSON array of 'Flux' to persist if payment valid
      *
      * @ORM\Column(type="text", nullable=true)
      */
      protected $flux_data;

      /**
       * @var string|null
       * Extra data to persist if payment valid
       *
       * @ORM\Column(type="text", nullable=true)
       */
       protected $extra_data;

    /**
     * @return string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Payment
     */
    public function setStatus(string $status): self
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getFluxData(): ?string
    {
        return $this->flux_data;
    }

    /**
     * @param string $flux_data
     * @return Payment
     */
    public function setFluxData(string $flux_data): self
    {
        $this->flux_data = $flux_data;
        return $this;
    }

    /**
     * @return string
     */
    public function getExtraData(): ?string
    {
        return $this->extra_data;
    }

    /**
     * @param string $extra_data
     * @return Payment
     */
    public function setExtraData(string $extra_data): self
    {
        $this->extra_data = $extra_data;
        return $this;
    }
}
