<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * ApiResource(
 *     attributes={"security"="is_granted('ROLE_ADMIN_NEWS_GERER_VIEW')"},
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_NEWS_GERER_LIST')"},
 *         "post"={"security"="is_granted('ROLE_ADMIN_NEWS_GERER_EDIT')"}
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_NEWS_GERER_VIEW')"},
 *         "put"={"security"="is_granted('ROLE_ADMIN_NEWS_GERER_EDIT')"},
 *     },
 *     normalizationContext={"groups"={"read"}},
 *     denormalizationContext={"groups"={"write"}}
 * )
 * @ORM\Entity(repositoryClass="App\Repository\NewsRepository")
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Table(name="news")
 */
class News
{
    use TimestampableEntity,
        NameSlugContentEntityTrait,
        EnablableEntityTrait;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
    * @var \Application\Sonata\MediaBundle\Entity\Media
    * @ORM\ManyToOne(targetEntity="App\Application\Sonata\MediaBundle\Entity\Media", cascade={"persist"}, fetch="LAZY")
    * @ORM\JoinColumn(name="media_id", referencedColumnName="id")
    */
    protected $media;

    /**
     * @var bool
     *
     * @ORM\Column(type="boolean", name="visible_by_all_groups")
     */
    private $visibleByAllGroups = true;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="news")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
     */
    private $user;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
    * Get media
    * @return
    */
    public function getMedia()
    {
        return $this->media;
    }

    /**
    * Set media
    * @return $this
    */
    public function setMedia($media)
    {
        $this->media = $media;
        return $this;
    }

    /**
     * @return bool
     */
    public function isVisibleByAllGroups(): bool
    {
        return $this->visibleByAllGroups;
    }

    /**
     * @param bool $visibleByAllGroups
     * @return News
     */
    public function setVisibleByAllGroups(bool $visibleByAllGroups)
    {
        $this->visibleByAllGroups = $visibleByAllGroups;
        return $this;
    }

    public function __toString(): string
    {
        $return = '';

        if ($this->getName() != null) {
            $return = $this->getName();
        }
        if ($this->getCreatedAt() != null) {
            $return .= ' (crée le '.$this->getCreatedAt()->format('d/m/Y H:i').')';
        }
        return $return;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }
}
