<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * ApiResource(
 *     attributes={"security"="is_granted('ROLE_ADMIN_ADHERENT_COTISATIONS_GERER_VIEW') or is_granted('ROLE_ADMIN_PRESTATAIRE_COTISATIONS_GERER_VIEW')"},
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_ADHERENT_COTISATIONS_GERER_LIST') or is_granted('ROLE_ADMIN_PRESTATAIRE_COTISATIONS_GERER_LIST')"},
 *         "post"={"security"="is_granted('ROLE_ADMIN_ADHERENT_COTISATIONS_GERER_EDIT') or is_granted('ROLE_ADMIN_PRESTATAIRE_COTISATIONS_GERER_EDIT')"}
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_ADHERENT_COTISATIONS_GERER_LIST') or is_granted('ROLE_ADMIN_PRESTATAIRE_COTISATIONS_GERER_VIEW')"},
 *         "put"={"security"="is_granted('ROLE_ADMIN_ADHERENT_COTISATIONS_GERER_EDIT') or is_granted('ROLE_ADMIN_PRESTATAIRE_COTISATIONS_GERER_EDIT')"},
 *     },
 *     normalizationContext={"groups"={"read"}},
 *     denormalizationContext={"groups"={"write"}}
 * )
 * Cotisation d'un utilisateur
 *
 * @ORM\Entity
 * @ORM\Table(name="cotisationinfos")
 */
class CotisationInfos
{
    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\OneToOne(targetEntity="Cotisation", cascade={"all"}, mappedBy="cotisationInfos")
     */
    protected $cotisation;

    /**
     * @var int
     *
     * @ORM\Column(name="annee", type="integer", length=4)
     */
    private $annee;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="debut", type="date")
     */
    private $debut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fin", type="date")
     */
    private $fin;

    /**
     * RECU
     * @var bool
     *
     * @ORM\Column(name="recu", type="boolean", nullable=false)
     */
    private $recu;

    /**
     * Constructeur
     */
    public function __construct()
    {
        $now = new \DateTime();
        $this->annee = intval($now->format('Y'));
        $this->debut = $now;
        $this->fin = new \DateTime('+1 year');
        $this->recu = false;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return Cotisation
     */
    public function getCotisation(): ?Cotisation
    {
        return $this->cotisation;
    }

    /**
     * @param Cotisation $cotisation
     * @return Cotisation
     */
    public function setCotisation(Cotisation $cotisation)
    {
        $this->cotisation = $cotisation;
        return $this;
    }

    /**
     * @return int
     */
    public function getAnnee(): ?int
    {
        return $this->annee;
    }

    /**
     * @param int $annee
     * @return Cotisation
     */
    public function setAnnee(int $annee)
    {
        $this->annee = $annee;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDebut(): ?\DateTime
    {
        return $this->debut;
    }

    /**
     * @param \DateTime $debut
     * @return Cotisation
     */
    public function setDebut(\DateTime $debut)
    {
        $this->debut = $debut;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getFin(): ?\DateTime
    {
        return $this->fin;
    }

    /**
     * @param \DateTime $fin
     * @return Cotisation
     */
    public function setFin(\DateTime $fin)
    {
        $this->fin = $fin;
        return $this;
    }

    /**
     * @return bool
     */
    public function isRecu(): ?bool
    {
        return $this->recu;
    }

    /**
     * @param bool $recu
     * @return Cotisation
     */
    public function setRecu(bool $recu)
    {
        $this->recu = $recu;
        return $this;
    }
}
