<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\GeolocEntityTrait;
use App\Entity\EntityTrait\HasEcompteEntity;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * ApiResource(
 *     attributes={"security"="is_granted('ROLE_ADMIN_ADHERENT_GERER_VIEW')"},
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_ADHERENT_GERER_LIST')"},
 *         "post"={"security"="is_granted('ROLE_ADMIN_ADHERENT_GERER_EDIT')"}
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_ADHERENT_GERER_LIST')"},
 *         "put"={"security"="is_granted('ROLE_ADMIN_ADHERENT_GERER_EDIT') or object.user == user"},
 *     },
 *     normalizationContext={"groups"={"read"}},
 *     denormalizationContext={"groups"={"write"}}
 * )
 * @ORM\Entity(repositoryClass="App\Repository\AdherentRepository")
 * @ORM\Table(name="adherent")
 */
class Adherent
{
    use EnablableEntityTrait,
        TimestampableEntity,
        GeolocEntityTrait,
        HasEcompteEntity;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var User
     *
     * @ORM\OneToOne(targetEntity="User", cascade={"all"}, mappedBy="adherent", fetch="LAZY")
     */
    protected $user;

    /**
     * @var Groupe $groupe
     *
     * @ORM\ManyToOne(targetEntity="Groupe", inversedBy="adherents")
     */
    private $groupe;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCompte(): float
    {
        return $this->getEcompte();
    }

    public function setCompte(float $ecompte): self
    {
        $this->setEcompte($ecompte);

        return $this;
    }

    /**
     * @return User
     */
    public function getUser(): ?User
    {
        return $this->user;
    }

    /**
     * @param User $user
     * @return Prestataire
     */
    public function setUser(User $user): self
    {
        $this->user = $user;
        return $this;
    }

    /**
     * @param null|Groupe $groupe
     * @return $this
     */
    public function setGroupe(?Groupe $groupe): self
    {
        $this->groupe = $groupe;
        return $this;
    }

    /**
     * @return null|Groupe
     */
    public function getGroupe(): ?Groupe
    {
        return $this->groupe;
    }


    public function isEnabled(): bool
    {
        return $this->getUser()->isEnabled();
    }

    public function setEnabled($enabled): self
    {
        $this->getUser()->setEnabled($enabled);
        return $this;
    }

    public function __toString(): string
    {
        if (!empty($this->getUser())) {
          if (!empty($this->getUser()->getLastname().$this->getUser()->getFirstname())) {
            return $this->getUser()->getLastname().' '.$this->getUser()->getFirstname();
          }
          if (!empty($this->getUser()->getUsername())) {
            return $this->getUser()->getUsername();
          }
        }
        return 'Adhérent ['.$this->getId().']';
    }
}
