<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller;

use App\Entity\Groupe;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class GroupeController extends FrontController
{
    protected $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * @Route("/groupes", name="liste_groupe")
     */
    public function listeGroupeAction()
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        return $this->render('groupe/liste.html.twig', array(
            'groupes' => $this->em->getRepository(Groupe::class)->findBy(array('enabled' => true), array('createdAt' => 'DESC'))
        ));
    }


    /**
     * @Route("/groupe/{slug}", name="show_groupe")
     */
    public function showGroupeAction(Groupe $groupe)
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        return $this->render('groupe/show.html.twig', array(
            'groupe' => $groupe
        ));
    }
}
