<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller\CRUD;

use App\Util\WordpressUtil;
use Sonata\AdminBundle\Datagrid\ProxyQueryInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

class PrestataireCRUDController extends CRUDController
{
    protected $wp;

    public function __construct(WordpressUtil $wp)
    {
        $this->wp = $wp;
    }

    /**
     * @param array|int|null  If $id is null, sync all the Prestataires
     */
    protected function syncToWordpress($id)
    {
        if ($this->wp->runSync($id)) {
            $this->addFlash('sonata_flash_success', 'Synchronisation vers Wordpress effectuée');
        }

        return new RedirectResponse(
            $this->admin->generateUrl('list', ['filter' => $this->admin->getFilterParameters()])
        );
    }

    public function syncAllWpAction()
    {
        return $this->syncToWordpress(null);
    }

    public function syncWpAction($id)
    {
        if (!$this->admin->hasSubject()) {
            throw new NotFoundHttpException(sprintf('Unable to find the Prestataire with id: %s', $id));
        }

        return $this->syncToWordpress($id);
    }

    public function batchActionSyncWp(ProxyQueryInterface $query)
    {
        $ids = [];
        $selected = $query->execute();

        foreach ($selected as $e) {
            $ids[] = $e->getId();
        }

        return $this->syncToWordpress($ids);
    }
}
