<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use App\Admin\FluxAdmin;
use App\Entity\User;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType as SChoiceType;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * Administration des reconversions (transfert d'un prestataire au siège)
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class ReconversionAdmin extends FluxAdmin
{
    protected $security;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $user = $this->security->getUser();
        $query = parent::createQuery($context);
        $query
            ->andWhere($query->getRootAliases()[0].".type = :type")
            ->setParameter('type', 'reconversion');
        ;
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('createdAt', null, array('label' => 'Date'))
            ->addIdentifier('type', null, array('label' => 'Type'))
            ->addIdentifier('operateur', User::class, array('label' => 'Operateur'))
            ->addIdentifier('expediteur', null, array('label' => 'Expediteur'))
            ->addIdentifier('destinataire', null, array('label' => 'Destinataire'))
            ->add('montant', null, array('label' => 'Montant initial'))
            ->add('tauxreconversion', null, array('label' => 'Taux reconversion'))
            ->add('montantareconvertir', null, array('label' => 'Montant à transférer'))
            ->add('reference', null, array('label' => 'Reference'))
            ->add('reconverti', null, array('label' => 'Reconverti ?', 'datatype' => 'App.Flux', 'template' => 'block/reconverti_field.html.twig'))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->remove('transfert_or_transaction')
            ->remove('type')
            ->remove('operateur')
        ;
    }
    
    //Surcharge pour que tous les champs visibles à l'écran soient présent dans l'export
    public function getExportFields()
    {
        return [
            'Date'                  => 'createdAt',
            'Opérateur'             => 'operateur',
            'Expéditeur'            => 'expediteur',
            'Destinataire'          => 'destinataire',
            'Montant initial'       => 'montant',
            'Taux de reconversion'  => 'tauxreconversion',
            'Montant à transférer'  => 'montantareconvertir',
            'Réference'             => 'reference',
            'Reconverti ? (1=oui)'  => 'reconverti'
        ];
    }

}
