<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use App\Entity\User;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Security\Core\Security;

/**
 * Administration des pages
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class PageAdmin extends AbstractAdmin
{
    protected $security;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'updatedAt',
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    public function configure()
    {
        parent::configure();
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
        $datagridMapper
            ->add('user')
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $page = $this->getSubject();
        if ($this->isCurrentRoute('create')) {
            $page->setUser($this->security->getUser());
        }
        $formMapper
            ->add('user', HiddenType::class, array(
                'data' => $this->getConfigurationPool()->getContainer()->get('security.token_storage')->getToken()->getUser()->getId(),
                'data_class' => null,
                'entity_class' => User::class,
                'em' => $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager()
            ))
            ->add('name', TextType::class, array(
                'label' => 'Titre :',
                'required' => true
            ))
            ->add('content', CKEditorType::class, array(
                'label' => 'Contenu :',
                'required' => true
            ))
            ->add('metaDescription', TextType::class, array(
                'label' => 'Meta Description :',
                'required' => true
            ))
            ->add('metaKeywords', TextType::class, array(
                'label' => 'Meta Keywords :',
                'required' => true
            ))
            ->add('template', TextType::class, array(
                'label' => 'Template :',
                'required' => false
            ))
            ->add('css', TextareaType::class, array(
                'label' => 'CSS :',
                'required' => false
            ))
            ->add('js', TextareaType::class, array(
                'label' => 'JS :',
                'required' => false
            ))
            ->add('enabled', CheckboxType::class, array(
                'label' => 'Activé ?',
                'label_attr' => array('class' => 'checkbox-inline'),
                'required' => false
            ))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('user', null, array('label' => 'Auteur'))
            ->addIdentifier('name', null, array('label' => 'Titre'))
            // ->add('enabled', null, array(
            //     'label' => 'Activé',
            //     'editable' => true
            // ))
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    public function getBatchActions()
    {
        $actions = parent::getBatchActions();
        unset($actions['delete']);

        return $actions;
    }
}
