<?php

namespace App\Form\Type;

use App\Entity\Comptoir;
use App\Entity\Groupe;
use App\Entity\Prestataire;
use App\Entity\TransfertPrestataireComptoir;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransfertPrestataireComptoirFormType extends TransfertFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('destinataire', HiddenType::class, array(
                'data' => $this->security->getUser()->getComptoirsgere()->getId(),
                'data_class' => null,
                'entity_class' => Comptoir::class,
                'em' => $this->em
            ))
            ->add('expediteur', EntityType::class, array(
                'class' => Prestataire::class,
                'choices' =>  $this->em->getRepository(Prestataire::class)->findBy(array('enabled' => true), array('raison' => 'ASC')),
                'placeholder' => 'Prestataire',
                'required' => true,
                'label' => 'Prestataire :',
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransfertPrestataireComptoir::class,
        ));
    }

    public function getParent()
    {
        return TransfertFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransfertPrestataireComptoir';
    }
}
