<?php

namespace App\Form\Type;

use App\Entity\Comptoir;
use App\Entity\Groupe;
use App\Entity\Siege;
use App\Entity\TransfertGroupeSiege;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransfertGroupeSiegeFormType extends TransfertFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', EntityType::class, array(
                'class' => Groupe::class,
                'choices' =>  $this->em->getRepository(Groupe::class)->findBy(array('enabled' => true), array('name'=> 'ASC')),
                'choice_label' => function ($choice) {
                    return ((!empty($choice->getName())?$choice->getName():'Groupe').' ('.$choice->getCompte().')');
                },
                'placeholder' => 'Groupe',
                'required' => true,
                'label' => 'Groupe :',
            ))
            ->add('destinataire', HiddenType::class, array(
                'data' => 1,
                'data_class' => null,
                'entity_class' => Siege::class,
                'em' => $this->em
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransfertGroupeSiege::class,
        ));
    }

    public function getParent()
    {
        return TransfertFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransfertGroupeSiege';
    }
}
