<?php

namespace App\Form\Type;

use App\Entity\Siege;
use Doctrine\ORM\EntityManagerInterface;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SiegeFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, array(
                'label' => 'Nom :',
                'required' => true
            ))
            ->add('compte', NumberType::class, array(
                'label' => 'Solde de monnaie actuellement au siège :',
                'required' => true
            ))
            // ->add('content', CKEditorType::class, array(
            //     'label' => 'Description :',
            //     'required' => false
            // ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Siege::class,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formSiege';
    }
}
