<?php

namespace App\Form\Type;

use App\Entity\Usergroup;
use App\Form\Type\RegistrationFormType;
use App\Form\Type\SiegeFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class InstallFormType extends AbstractType
{
    protected $container;
    protected $em;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        $this->container = $container;
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('siege', SiegeFormType::class, array(
                'label' => 'Siège :',
                'required' => true
            ))
            ->add('user', RegistrationFormType::class, array(
                'label' => 'UTILISATEUR SUPER ADMIN :',
                'required' => true
            ))
            ->add('save', SubmitType::class, ['label' => "Installer le système"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => null,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formInstallation';
    }
}
