<?php

namespace App\Entity;

use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use App\Entity\EntityTrait\EnablableEntityTrait;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity
 * @ORM\Table(name="typepresta")
 */
class TypePrestataire
{
    use NameSlugContentEntityTrait,
        TimestampableEntity,
        EnablableEntityTrait;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var ArrayCollection|Prestataire[]
     * @ORM\OneToMany(targetEntity="Prestataire", mappedBy="typeprestataire")
     */
    private $prestataires;

    public function getId(): ?int
    {
        return $this->id;
    }
}
