<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSFERT
 *  - GROUPES LOCAUX    =>     COMPTOIRS                (Transfert du groupe au comptoir)
 *
 * @ORM\Entity()
 */
class TransfertGroupeComptoir extends Transfert
{
    /**
     * @ORM\OneToOne(targetEntity="Groupe")
     * @ORM\JoinColumn(name="groupe_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'groupe_comptoir';
    }
}
