<?php

namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\Groupe;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransfertComptoirGroupe;
use App\Entity\TransfertGroupeComptoir;
use App\Entity\Usergroup;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\GroupeInfosFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransfertComptoirGroupeFormType;
use App\Form\Type\TransfertGroupeComptoirFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserGestionnaireGroupeController extends FluxController
{
    /**
     * @Route("/user/groupe/infos", name="groupe_infos")
     * @Security("is_granted('ROLE_GESTION_GROUPE') or is_granted('ROLE_CONTACT')")
     */
    public function groupeInfosAction(Request $request)
    {
        $form = $this->createForm(GroupeInfosFormType::class, $this->getUser()->getGroupesgere());
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Groupe local bien modifié !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->redirectToRoute('index');
    }

    /**
     * @Route("/user/groupe/transfert/comptoir/", name="transfertGroupeComptoir")
     * @IsGranted("ROLE_GESTION_GROUPE")
     */
    public function transfertGroupeComptoirAction(Request $request)
    {
        $entity = new TransfertGroupeComptoir();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertGroupeComptoirFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->getUser()->getGroupesgere()->getCompte(),
            $this->translator->trans('Transfert bien effectué !'),
            $this->translator->trans('Transfert à un comptoir')
        );
    }

      /**
     * @Route("/user/groupe/retour/comptoir/", name="transfertComptoirGroupe")
     * @IsGranted("ROLE_GESTION_GROUPE")
     */
    public function transfertComptoirGroupeAction(Request $request)
    {
        $entity = new TransfertComptoirGroupe();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertComptoirGroupeFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->getUser()->getGroupesgere()->getCompte(),
            $this->translator->trans('Retour bien effectuée !'),
            $this->translator->trans('Retour au groupe')
        );
    }

}
