<?php
namespace App\Controller\Rest;

use App\Controller\ExceptionFOSRestController;
use App\Entity\Groupe;
use App\Entity\User;
use Nelmio\ApiDocBundle\Annotation\ApiDoc;
use Nelmio\ApiDocBundle\Annotation\Model;
use Nelmio\ApiDocBundle\Annotation\Security;
use Swagger\Annotations as SWG;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 *
 * Types de transfert : (Les transferts dans la structure sont les flux de billets détenus par les opérateurs.)
 *
 *  - SIEGE             =>     GROUPES LOCAUX           (Transfert du siège au groupe)
 *  - GROUPES LOCAUX    =>     COMPTOIRS                (Transfert du groupe au comptoir)
 *  - COMPTOIRS         =>     GROUPES LOCAUX           (Transfert du comptoir au groupe)
 *  - COMPTOIRS         =>     ADHERENTS                (Diffusion de monnaie papier auprès des adhérents)
 *  - COMPTOIRS         =>     PRESTATAIRES             (Diffusion de monnaie papier auprès des prestataires)
 *  - PRESTATAIRES      =>     COMPTOIRS                (Reconversion)
 *
 *
 * Types de transaction :
 *
 *   - PRESTATAIRES     =>    ADHERENTS         (Virement vers un adherent)
 *   - PRESTATAIRES     =>    PRESTATAIRES      (Virement entre prestataires)
 *   - ADHERENTS        =>    PRESTATAIRES      (Paiement numérique)
 *
 */
class FluxController extends ExceptionFOSRestController
{
    /**
     * Transfert du siège au groupe
     *
     * @Route("/transfert/siege/groupe/{}", methods={"GET"})
     * @SWG\Response(
     *     response=200,
     *     description="Transfert du siège au groupe",
     *     @SWG\Schema(
     *         type="string"
     *     )
     * )
     * @SWG\Parameter(
     *     name="user",
     *     in="query",
     *     type="integer",
     *     description="The user"
     * )
     * @SWG\Tag(name="Utilisateurs")
     * Security("is_granted('add_tr_sie_grp', user)")
     */
    public function tranfertSiegeGroupeAction(User $user, Groupe $groupe)
    {
        try {
            $view = $this->createView();

            $view->setData('yes');
            return $this->handleView($view);
            //return new JsonResponse('yes');
        } catch (\Exception $e) {
            $this->throwFosrestSupportedException($exception);
        }
    }

    protected function tranfert(User $operateur, $expediteur, $destinataire)
    {
        //TODO
    }
}
