<?php

namespace App\Admin;

use App\Admin\UserAdmin;
use App\Entity\Cotisation;
use App\Entity\CotisationPrestataire;
use App\Entity\Geoloc;
use App\Entity\Groupe;
use App\Entity\Prestataire;
use App\Entity\User;
use App\Entity\Usergroup;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationFormType;
use Doctrine\ORM\Query;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use FOS\UserBundle\Model\UserManagerInterface;
use Knp\Menu\ItemInterface as MenuItemInterface;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Admin\AdminInterface;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Security\Core\Security;

/**
 * Administration des prestataires
 *
 * LOCO : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class PrestataireAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'prestataire';
    protected $baseRoutePattern = 'prestataire';
    protected $security;
    protected $datagridValues = [
        // reverse order (default = 'ASC')
        '_sort_order' => 'DESC',
        // name of the ordered field (default = the model's id field, if any)
        '_sort_by' => 'updatedAt',
        // '_page' => 1,
        // '_per_page' => 32
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    public function configure()
    {
        parent::configure();
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $user = $this->security->getUser();
        $query = parent::createQuery($context);
        $query
            ->innerJoin($query->getRootAliases()[0] .'.user', 'u')
            ->addSelect('u')
        ;
        if ($user->isGranted('ROLE_GESTION_GROUPE') || $user->isGranted('ROLE_CONTACT')) {
            if (empty($user->getGroupesgere())) {
                $query->andWhere('false');
            } else {
                $groupe = $user->getGroupesgere();
                $query
                    ->andWhere($query->getRootAliases()[0] . '.groupe = :group')
                    ->setParameter('group', $groupe)
                ;
            }
        }
        return $query;
    }

    protected function configureSideMenu(MenuItemInterface $menu, $action, AdminInterface $childAdmin = null)
    {
        if (!$childAdmin && !in_array($action, ['edit', 'show'])) {
            return;
        }
        $user = $this->security->getUser();
        $admin = $this->isChild() ? $this->getParent() : $this;
        $id = $admin->getRequest()->get('id');
        $user = $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(User::class)->findOneBy(array('prestataire' => $id));

        if ($this->isGranted('EDIT') && $user != null) {
            $menu->addChild("Modifier l'utilisateur", [
                'uri' => $this->getConfigurationPool()->getContainer()->get('router')->generate('admin_app_user_edit', ['id' => $user->getId()], UrlGeneratorInterface::ABSOLUTE_URL)
            ]);
        }
        $menu->addChild("Ajouter une cotisation", [
            'uri' => $this->getConfigurationPool()->getContainer()->get('router')->generate('cotisation_prestataire_create', ['expediteur' => $id], UrlGeneratorInterface::ABSOLUTE_URL)
        ]);
        $menu->addChild("Voir les cotisations", [
            'uri' => $this->getConfigurationPool()->getContainer()->get('router')->generate('cotisation_prestataire_list', ['filter' => array('expediteur' => array('value' => $id))], UrlGeneratorInterface::ABSOLUTE_URL)
        ]);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        // Initialize prestataire
        $presta = $this->getSubject();
        $user = $this->security->getUser();
        $now = new \DateTime();
        $cotisation = null;
        if ($this->isCurrentRoute('create')) {
            if ($user->isGranted('ROLE_CONTACT') or $user->isGranted('ROLE_COMPTOIR')) {
                $user->setEnabled(false);
            } else {
                $user->setEnabled(true);
            }
            $user = $this->userManager->createUser();
            $groupe = $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Usergroup::class)->findOneByName('Prestataire');
            $user->addGroup($groupe);
            $user->addRole('ROLE_PRESTATAIRE');
            $user->setPrestataire($presta);
            $presta->setUser($user);
        }
        // if (count($presta->getUser()->getCotisations()) <= 0) {
        //     $cotisation = new Cotisation();
        //     $cotisation->setOperateur($presta->getUser());
        //     $cotisation->setExpediteur($presta);
        //     $cotisation->setDebut($now);
        //     $cotisation->setFin(new \DateTime('+ 1 year'));
        //     $presta->getUser()->addCotisation($cotisation);
        // }
        if ($presta->getGeoloc() == null) {
            $presta->setGeoloc(new Geoloc());
        }

        // get the current Image instance
        $imageHelp = null;
        if (!empty($presta) && !empty($presta->getMedia())) {
            $image = $presta->getMedia();
            if ($image && ($webPath = $image->getWebPath())) {
                // get the container so the full path to the image can be set
                $container = $this->getConfigurationPool()->getContainer();
                $fullPath = $container->get('request_stack')->getCurrentRequest()->getBasePath().'/'.$webPath;
                // add a 'help' option containing the preview's img tag
                $imageHelp = '<img src="'.$fullPath.'" class="admin-preview" />';
            }
        }

        $formMapper
            ->tab('Prestataire')
                ->with('Identité', ['class' => 'col-md-7'])
                    ->add('typeprestataire', null, array(
                        'label' => 'Type :',
                        'required' => true,
                        'expanded' => true
                    ))
                    ->add('user.firstname', TextType::class, array(
                        'label' => 'Prénom :',
                        'required' => false
                    ))
                    ->add('user.lastname', TextType::class, array(
                        'label' => 'Nom :',
                        'required' => false
                    ));
        if (!$this->isCurrentRoute('create')) {
            $formMapper
                ->add('user.username', TextType::class, array(
                    'label' => 'Username :',
                    'required' => false,
                    'disabled' => true
                ));
        }
        $formMapper
                    ->add('user.phone', TextType::class, array(
                        'label' => 'Téléphone :',
                        'required' => false
                    ))
                    ->add('user.email', TextType::class, array(
                        'label' => 'Email :',
                        'required' => true
                    ))
                    ->add('groupe', ChoiceType::class, array(
                        'required' => true,
                        'label' => 'Groupe local :',
                        'choices' => $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Groupe::class)->findAll(),
                        'choice_label' => 'name',
                        'placeholder' => 'Choisir un groupe',
                    ))
                ->end()
                ->with('Addresse', ['class' => 'col-md-5'])
                    ->add('geoloc.adresse', TextType::class, array(
                        'label' => 'Addresse :',
                        'required' => false
                    ))
                    ->add('geoloc.cpostal', TextType::class, array(
                        'label' => 'Code postal :',
                        'required' => false
                    ))
                    ->add('geoloc.ville', TextType::class, array(
                        'label' => 'Ville :',
                        'required' => false
                    ))
                    // ->add('geoloc.lat', TextType::class, array(
                    //     'label' => 'Latitude :',
                    //     'required' => false
                    // ))
                    // ->add('geoloc.lon', TextType::class, array(
                    //     'label' => 'Longitude :',
                    //     'required' => false
                    // ))
                ->end()
                ->with('Image', ['class' => 'col-md-5'])
                    ->add('media', MediaType::class, array(
                        'provider' => 'sonata.media.provider.image',
                        'context' => 'prestataire',
                        'help' => $imageHelp,
                        'required' => false
                    ))
                ->end()
                ->with('Société', ['class' => 'col-md-7'])
                    ->add('raison', TextType::class, array(
                        'label' => 'Raison :',
                        'required' => true
                    ))
                    ->add('statut', TextType::class, array(
                        'label' => 'Statut :',
                        'required' => false
                    ))
                    ->add('siret', TextType::class, array(
                        'label' => 'SIRET :',
                        'required' => true
                    ))
                    ->add('iban', TextType::class, array(
                        'label' => 'IBAN :',
                        'required' => true
                    ))
                    ->add('responsable', TextType::class, array(
                        'label' => 'Responsable :',
                        'required' => false
                    ))
                    ->add('metier', TextType::class, array(
                        'label' => 'Métier responsable :',
                        'required' => false
                    ))
                    ->add('horaires', TextType::class, array(
                        'label' => 'Horaires',
                        'required' => false
                    ))
                    ->add('description', CKEditorType::class, array(
                        'label' => 'Description',
                        'required' => false
                    ))
                ->end();
        // if ($cotisation != null) {
        //     //@TODO : cotisationS
        //     $formMapper
        //         ->with('Cotisation', ['class' => 'col-md-5'])
        //             ->add('user.cotisations.last.cotisationInfos.annee', TextType::class, array('label' => 'Année', 'data' => intval($now->format('Y'))))
        //             ->add('user.cotisations.last.montant', MoneyType::class, array(
        //                 'label' => 'Montant',
        //                 'empty_data' => floatval($this->getConfigurationPool()->getContainer()->getParameter('app.cotisation_montant'))
        //             ))
        //             ->add('user.cotisations.last.moyen', ChoiceType::class, array(
        //                 'required' => true,
        //                 'label' => 'Moyen :',
        //                 'choices' => MoyenEnum::getAvailableTypes(),
        //                 'choice_label' => function ($choice) {
        //                     return MoyenEnum::getTypeName($choice);
        //                 },
        //             ))
        //             ->add('user.cotisations.last.cotisationInfos.recu', CheckboxType::class, array(
        //                 'label' => 'Reçu',
        //                 'required' => false
        //             ))
        //         ->end();
        //     if (!$this->isCurrentRoute('create')) {
        //         $formMapper
        //             ->with('Date', ['class' => 'col-md-5'])
        //                 ->add('user.cotisations.last.cotisationInfos.debut', DateType::class, array(
        //                     'label' => 'Date de début',
        //                     'data' => new \DateTime(),
        //                     'widget' => 'single_text',
        //                     'html5' => false,
        //                     'attr' => ['class' => 'js-datepicker'],
        //                 ))
        //                 ->add('user.cotisations.last.cotisationInfos.fin', DateType::class, array(
        //                     'label' => 'Date de fin',
        //                     'data' => new \DateTime('+ 1 year'),
        //                     'widget' => 'single_text',
        //                     'html5' => false,
        //                     'attr' => ['class' => 'js-datepicker'],
        //                 ))
        //             ->end();
        //     }
        // } else {
        // if (count($presta->getUser()->getCotisations()) > 0) {
        //     $formMapper
        //         ->end()
        //         ->tab('Cotisation')
        //             ->with('Cotisations', ['class' => 'col-md-12'])
        //                 ->add('user.cotisations', CollectionType::class, array(
        //                     'entry_type' => CotisationFormType::class,
        //                     // 'data' => $presta->getUser()->getCotisations(),
        //                     // 'entry_options' => array(
        //                     // //     'class' => Cotisation::class,
        //                     // //     'choices' =>  $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(CotisationPrestataire::class)->findBy(array('expediteur' => $presta)),
        //                     // //     'choice_label' => 'reference',
        //                     // //     'placeholder' => 'Cotisation',
        //                     // //     'required' => false,
        //                     //     'label' => false
        //                     // ),
        //                     'by_reference' => false,
        //                     'allow_add' => false,
        //                     'allow_delete' => false,
        //                     'disabled' => true,
        //                 ), array(
        //                     'admin_code' => 'admin.prestataire.cotisations'
        //                 ))
        //             ->end()
        //     ;
        // }
            // $formMapper
            //     ->tab('Cotisation '.$cotisation->getAnnee())
            //         ->with('Cotisation', ['class' => 'col-md-5'])
            //             ->add('user.cotisations.get('.$cnt.').cotisationInfos.annee', TextType::class, array('label' => 'Année', 'data' => $now->format('Y')))
            //             ->add('user.cotisations.get('.$cnt.').montant', TextType::class, array('label' => 'Montant'))
            //             ->add('user.cotisations.get('.$cnt.').moyen', ChoiceType::class, array(
            //                 'required' => true,
            //                 'label' => 'Moyen :',
            //                 'choices' => MoyenEnum::getAvailableTypes(),
            //                 'choice_label' => function ($choice) {
            //                     return MoyenEnum::getTypeName($choice);
            //                 },
            //             ))
            //             ->add('user.cotisations.get('.$cnt.').cotisationInfos.recu', CheckboxType::class, array('label' => 'Reçu'))
            //         ->end()
            //         ->with('Date', ['class' => 'col-md-5'])
            //             ->add('user.cotisations.get('.$cnt.').cotisationInfos.debut', DateType::class, array(
            //                 'label' => 'Date de début',
            //                 'data' => new \DateTime(),
            //                 'widget' => 'single_text',
            //                 'html5' => false,
            //                 'attr' => ['class' => 'js-datepicker'],
            //             ))
            //             ->add('user.cotisations.get('.$cnt.').cotisationInfos.fin', DateType::class, array(
            //                 'label' => 'Date de fin',
            //                 'data' => new \DateTime('+ 1 year'),
            //                 'widget' => 'single_text',
            //                 'html5' => false,
            //                 'attr' => ['class' => 'js-datepicker'],
            //             ))
            //         ->end()
            // ;

        $formMapper->end();
        $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager();
        $formMapper->getFormBuilder()->addEventListener(FormEvents::POST_SUBMIT, function (FormEvent $event) use ($em) {
            $prestataire = $event->getData();
            $user = $prestataire->getUser();
            if (!$user || null === $user->getId()) {
                $repo = $em->getRepository(User::class);
                $emailExist = $repo->findBy(array('email' => $user->getEmail()));
                if (count($emailExist) > 0) {
                    $event->getForm()->get('user__email')->addError(new FormError('Courriel déjà utilisé !'));
                } else {
                    $user->setUsername($user->getEmail());
                }
            }
        });
        parent::configureFormFields($formMapper);
    }

    public function preUpdate($prestataire)
    {
        $this->prePersist($prestataire);
    }

    public function prePersist($prestataire)
    {
        $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager();

        if (empty($prestataire->getUser()->getUsername())) {
            $prestataire->getUser()->setUsername($prestataire->getUser()->getEmail());
        }
        if (empty($prestataire->getUser()->getPassword())) {
            // $tokenGenerator = $this->getConfigurationPool()->getContainer()->get('fos_user.util.token_generator');
            // $password = substr($tokenGenerator->generateToken(), 0, 12);
            $bytes = random_bytes(64);
            $password = rtrim(strtr(base64_encode($bytes), '+/', '-_'), '=');
            $prestataire->getUser()->setPassword($password);
            // TODO : send email to user
        }
        $this->userManager->updateUser($prestataire->getUser());
        $prestataire->getUser()->createEmailToken();
        $em->persist($prestataire->getUser());
        $em->persist($prestataire);
        $em->flush();
        // TODO : envoyer un mail au nouvel utilisateur avec l'emailtoken via le dispatch d'un event
        // $this->eventDispatcher->dispatch(FOSUserEvents::REGISTRATION_COMPLETED, new FilterUserResponseEvent($adherent->getUser(), $this->getRequest(), $response));
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
        $datagridMapper
            ->add('typeprestataire')
            ->add('raison')
            ->add('statut')
        ;
    }

    public function getTemplate($name)
    {
        if ($name == 'edit') {
            return 'presta/block/base_edit_prestataires.html.twig';
        }

        return parent::getTemplate($name);
    }

    /**
     * @param UserManagerInterface $userManager
     */
    public function setUserManager(UserManagerInterface $userManager): void
    {
        $this->userManager = $userManager;
    }

    /**
     * @return UserManagerInterface
     */
    public function getUserManager()
    {
        return $this->userManager;
    }

    protected function configureListFields(ListMapper $listMapper): void
    {
        unset($this->listModes['mosaic']);
        $user = $this->security->getUser();
        $listMapper
            ->addIdentifier('user.username')
            ->addIdentifier('user.email')
            ->addIdentifier('raison')
            ->addIdentifier('groupe', null, array(
                'label' => 'Groupe',
                'sortable' => true,
                'sort_field_mapping' => array('fieldName' => 'name'),
                'sort_parent_association_mappings' => array(array('fieldName' => 'groupe'))
            ))
        ;
        if ($user->isGranted('ROLE_GESTION_GROUPE')) {
            $listMapper
                ->addIdentifier('user.enabled', null, array('label' => 'Activé', 'datatype' => 'App.User', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
            ;
        }
        $listMapper
            ->addIdentifier('user.createdAt')
        ;

        // if ($this->isGranted('ROLE_ALLOWED_TO_SWITCH')) {
        //     $listMapper
        //         ->addIdentifier('user.impersonating', 'string', ['template' => '@SonataUser/Admin/Field/impersonating.html.twig'])
        //     ;
        // }
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    public function getBatchActions()
    {
        $actions = parent::getBatchActions();
        unset($actions['delete']);

        return $actions;
    }
}
