# Le Kohinos

Outil de gestion, destiné aux associations désireuses de porter une Monnaie Locale Complémentaire

Communauté de développement pour une économie plus juste et solidaire.



# Installation

## Pré-requis
Pour pouvoir fonctionner un certain nombre de packages système sont requis. Vous devez utiliser yum/apt pour les installer

Les packages PHP `php7.2-cli php-mbstring php-zip php-curl php-xml`

Pour la base de donnée, vous pouvez choisir entre `mysql-server` et `mariadb-server`

## Mysql
Il vous faut un utilisateur `user` qui peut se logger avec un mot de passe `passwd` ainsi qu'une database existante `nom_bdd`.




## Installation de Kohinos
Attention, il est préférable d'installer dans une bdd (database) vierge.
Dans le cas contraire, modifier le fichier de migration une fois généré mais avant application (src/Migrations/).

- créer un fichier .env avec le contenu suivant
```
#dev, test ou prod#
APP_ENV=dev
#debug 0 ou 1#
APP_DEBUG=1
#token secret (ne pas changer)#
APP_SECRET=9hgz21afe254dj7f552gtya2f01dd5f2
#prefix des tables#
DATABASE_PREFIX=prefix_
#acces bdd#
DATABASE_URL=mysql://user:passw@localhost:3306/nom_bdd
#smtp#
MAILER_URL=smtp://localhost:25?encryption=&auth_mode=
```

- Installer composer si besoin

`curl -sS https://getcomposer.org/installer | php`

- Cloner le projet dans le dossier nomdudossier
- (avec votre identifiant et mot-de-passe Gitlab)

`git clone https://gitlab.com/Kohinos/kohinos.git nomdudossier`

- Naviguer vers `nomdudossier`

`cd nomdudossier`

- Installer les dépendances via composer (cela dépend des systèmes)

`composer install` ou bien `php ../composer.phar install`

- Générer le fichier de migration

`php bin/console doctrine:migrations:diff`

- Lancer la mise à jour de la base de données

`php bin/console doctrine:migrations:migrate`

- Charger les fixtures standards

`php bin/console hautelook:fixtures:load --purge-with-truncate`

- Charger les langues pour les interfaces (français + anglais)

`php bin/console lexik:translations:import`

- **dev uniquement :** charger les fixtures de dev (ce qui crée des éléments dans la BDD pour pouvoir tester les fonctionnalités)

`php bin/console hautelook:fixtures:load --purge-with-truncate --env=test`


- Si `public/bundles` est vide, sinon sauter l'étape suivante

`php bin/console assets:install --symlink`

- Supprimer le cache (si besoin)

`php bin/console cache:clear`

ou pour supprimer tous les dossiers de cache (plus rapide et plus efficace en cas de changement de structure de bdd)

`rm -rf var/cache/*`

- Sur un serveur :
  - Faire pointer l'adresse dans le dossier public.
  - Naviguer vers l'application et démarer le système.

- En local :
`php bin/console server:run`
  - Naviguer vers `http://127.0.0.1:8000`


## htaccess
En cas de problème, modifier le .htaccess (si apache < 2.4, il y a le public/.htaccessOLD qui peut être comptatible)

`vi public/.htaccess`

## Remarques
- La géolocalisation est difficile en local.
